IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CP_Cobros_Pendientes') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.[CP_Cobros_Pendientes]
END
GO


CREATE PROCEDURE [dbo].[CP_Cobros_Pendientes] 
	 @Filtrar_Fecha		TINYINT 
	,@Fecha_Desde		DateTime 
	,@Fecha_Hasta		DateTime
	,@Id_cliente		INT
	,@Id_Cobrador		Varchar(10)
	,@Det_Producto		INT=0

 
AS 
BEGIN
SET NOCOUNT ON
DECLARE @Sql		VARCHAR(MAX)
DECLARE @SqlSaldo	VARCHAR(MAX)
DECLARE @SqlSelect	VARCHAR(MAX)
DECLARE @SqlFrom	VARCHAR(MAX)
DECLARE @SqlWhere	VARCHAR(MAX)
DECLARE @SqlGroup	VARCHAR(MAX)

CREATE TABLE #Cobros_Pend  (
			 Fecha DATETIME
			,Fecha_Vence DATETIME
			,Descripcion VARCHAR(25)
			,Id_Trans INT
			,Nro_Cuota SMALLINT
			,Id_cliente INT
			,Razon_Social CHAR(100)
			,Importe DECIMAL(16,2)
			,Saldo 	DECIMAL(16,2)
			,Id_Tipo_Cbte Char(4)
			,Comprobante_Nro INT
			,Id_Estado_Cbte SMALLINT
			,Id_Cobrador Varchar(10)
			,Nombre_Cobrador CHAR(100)
			,Id_Interno INT IDENTITY(1,1)
			,Descrip_Producto	VARCHAR(8000)
		)

SET @SqlSelect = 'SELECT k.FECHA as Fecha,
                         k.Fecha_vence as Fecha_Vence,
						 k.Descripcion as Descripcion,
						 k.Id_Trans as Id_Trans,
						 k.Nro_Cuota as Nro_Cuota,
						 k.Id_cliente as Id_Cliente,
						 UPPER(CL.Razon_Social) as Razon_Social,
						 K.Importe as Importe,
						 k.Saldo as Saldo,
						 C.Id_Tipo_Cbte as Id_Tipo_Cbte,
						 C.Comprobante_Nro as Comprobante_Nro,
						 k.Id_Estado_Cbte as Id_Estado_Cbte,
						 UPPER(CL.id_COBRADOR) as Id_Cobrador,
						 V.Descripcion as Nombre_Cobrador'

IF (@Det_Producto<>0)
BEGIN
	SET @SqlSelect =@SqlSelect+ ',dbo.CF_Descrip_Cbte_Producto(C.Id_Trans) AS Det_Producto'
END 
ELSE
BEGIN
	SET @SqlSelect =@SqlSelect+ ','''' AS Det_Producto'
END 
SET @SqlFrom = 'FROM  Cbtes C , Clientes_Ctacte K, Clientes CL,  Cbtes_Tipos T,  Vendedores V'
----------------------------------------------------------------------------------------------------------------------
SET @SqlWhere = ' WHERE c.id_trans = k.id_trans 
                        AND K.ID_CLIENTE = CL.ID_CLIENTE
						AND C.ID_TIPO_CBTE = T.ID_TIPO_CBTE
						AND CL.ID_COBRADOR = V.ID_VENDEDOR 
						AND K.ID_ESTADO_CBTE IN (1,4)
						AND T.COMPROMETE_FACTURA IN (1,-1)
						AND K.SALDO <> 0'
						

					 
IF @Id_cliente <> 0
  BEGIN
	SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND C.Id_cliente  = ' +  cast(@id_Cliente  as varchar(12))
  END


IF ISNULL(@Id_Cobrador,'') <> ''
	BEGIN
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND CL.Id_Cobrador = ''' + @Id_Cobrador + ''''
	END


IF ISNULL(@Filtrar_Fecha,0) <> 0
BEGIN
	SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND k.FECHA_VENCE >= '''+ CONVERT(VARCHAR(8),@Fecha_Desde,112) +''''

	SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND k.FECHA_VENCE < '''+ CONVERT(VARCHAR(8),@Fecha_HASTA+1,112) +''''
END
----------------------------------------------------------------------------------------------------------------------
SET @SqlGroup = ' ORDER BY k.id_cliente,k.FECHA_VENCE '


SET @Sql = @SqlSelect +' '+ @SqlFrom + ' ' + @SqlWhere + ' ' + @SqlGroup 
PRINT @Sql
--EXECUTE (@Sql) 

CREATE INDEX IX_cobros_Pend____ ON  #Cobros_Pend (Id_Interno)

INSERT INTO #Cobros_Pend
EXEC(@sql)

SELECT * FROM #Cobros_Pend


DROP TABLE #Cobros_Pend

END

-- exec [CP_Cobros_Pendientes] 1,'20201101','20201130',0,'A'

-- exec [CP_Cobros_Pendientes] 1,'20201101','20201130',0,''
